/*
 * UpdateInformation.cpp
 *
 *  Created on: 12.03.2013
 *      Author: georg
 */

#include "UpdateInformation.h"
#include "CF30Window.h"

UpdateInformation::UpdateInformation() {

}

UpdateInformation::~UpdateInformation() {

}

/**
 * Updates the voltage while a comport is open.
 */
gint UpdateInformation::updateStatusinformationWhileConnected(gpointer data){
	if(data == 0){
		return 0;
	}

	int voltage = ((CF30Window*) data)->getVoltage();
	if(voltage == -1){
		((CF30Window*) data)->setVoltageLabel("Voltage:");
		return 0;
	}

	std::stringstream ss;
	ss << "Voltage: " << voltage << " mV";
	((CF30Window*) data)->setVoltageLabel(ss.str());

	return 1;
}

/**
 * Updates all informations in the treeview while a comport is open.
 */
gint UpdateInformation::updateInformationTreeview(gpointer data){
	if(data == 0){
		return 0;
	}

	// set information TreeView
	if(((CF30Window*) data)->updateInformationTreeView() == -1){
		return 0;
	}
	return 1;
}
